﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Core
{
    public static class Texture2DExtensions
    {
        public static Vector2 Center(this Texture2D texture)
        {
            return new Vector2(((float)texture.Width / 2), (float)texture.Height / 2);
        }

        public static Vector2 CenterShift(this Texture2D texture, int x, int y)
        {
            return new Vector2(((float)texture.Width / 2) + x, (float)texture.Height / 2); 
        }
    }
}
